/*
 * Decompiled with CFR 0.152.
 */
public final class PgbMemory {
    public PgbCart cart;
    public PgbVideo video;
    public PgbJoypad joy;
    public PgbNetplay net;
    public SoundChip soundChip;
    boolean soundOn;
    byte[] soundIO;
    public static final byte INT_JOYPAD = 16;
    public static final byte INT_SERIAL = 8;
    public static final byte INT_TIMER = 4;
    public static final byte INT_LCD = 2;
    public static final byte INT_VBLANK = 1;
    protected byte[] hiRAM;
    protected byte[] loRAM;
    public byte IF;
    public byte IE;
    public int tima;
    public int tma;
    public byte tac;
    protected boolean timerOn;
    protected int timeCounter;
    protected int timeLimit;
    public int div;
    public int cycles;
    public int cyclesLeft;
    public int cyclesSkipped;
    protected int sgbBitCounter;
    protected int sgbPacketCounter;
    protected byte[] sgbBuffer;
    protected boolean sgbListening;
    protected int sgbCommand;
    protected int sgbPackets;
    byte gbcRAM;
    int loRAMOffset;
    byte gbcSpeed;
    byte rHDMA1;
    byte rHDMA2;
    byte rHDMA3;
    byte rHDMA4;
    int hdmaSrc;
    int hdmaDst;
    boolean hdmaDone;
    byte hdmaLastMode;
    int hdmaStop;

    public PgbMemory(PgbCart pgbCart, PgbVideo pgbVideo, PgbJoypad pgbJoypad, PgbNetplay pgbNetplay) {
        this.cart = pgbCart;
        this.video = pgbVideo;
        this.joy = pgbJoypad;
        this.net = pgbNetplay;
        this.hiRAM = new byte[128];
        this.loRAM = new byte[32768];
        this.sgbBuffer = new byte[128];
        this.soundOn = true;
        this.soundChip = new SoundChip();
        this.soundIO = new byte[64];
        this.reset();
    }

    public void soundPlay() {
        this.soundChip.outputSound();
    }

    public int unsign(byte by) {
        return by & 0xFF;
    }

    public void reset() {
        this.tima = 0;
        this.tma = 0;
        this.tac = 0;
        this.timerOn = false;
        this.timeCounter = 0;
        this.timeLimit = 0;
        this.div = 44800;
        this.IF = 1;
        this.IE = 0;
        this.sgbBitCounter = 0;
        this.sgbPacketCounter = 0;
        this.sgbListening = false;
        this.sgbPackets = 1;
        this.gbcRAM = 0;
        this.loRAMOffset = 49152;
        this.gbcSpeed = (byte)126;
        this.cycles = 0;
        this.cyclesLeft = Integer.MAX_VALUE;
        this.recalcCyclesLeft();
        this.hdmaDone = true;
        this.hdmaLastMode = 0;
        this.soundIO[16] = -128;
        this.soundIO[17] = -65;
        this.soundIO[18] = -13;
        this.soundIO[20] = -65;
        this.soundIO[22] = 63;
        this.soundIO[23] = 0;
        this.soundIO[25] = -65;
        this.soundIO[26] = 127;
        this.soundIO[27] = -1;
        this.soundIO[28] = -97;
        this.soundIO[30] = -65;
        this.soundIO[32] = -1;
        this.soundIO[33] = 0;
        this.soundIO[34] = 0;
        this.soundIO[35] = -65;
        this.soundIO[36] = 119;
        this.soundIO[37] = -13;
        this.soundIO[38] = -15;
    }

    public void recalcCyclesLeft() {
        this.cyclesLeft = Integer.MAX_VALUE;
        if (this.timerOn && this.timeLimit - this.timeCounter < this.cyclesLeft) {
            this.cyclesLeft = this.timeLimit - this.timeCounter;
        }
        if (this.video.lcd_on && this.video.cyclesLeft() < this.cyclesLeft) {
            this.cyclesLeft = this.video.cyclesLeft();
        }
        if (this.net.cyclesLeft() < this.cyclesLeft) {
            this.cyclesLeft = this.net.cyclesLeft();
        }
    }

    public final void cycle(int n) {
        this.cycles += n;
        if (this.cycles > this.cyclesLeft) {
            this.div -= this.cyclesLeft;
            if (this.div < 0) {
                this.div = 65280;
            }
            if (this.timerOn) {
                this.timeCounter += this.cyclesLeft;
                if (this.timeCounter >= this.timeLimit) {
                    this.timeCounter = 0;
                    ++this.tima;
                }
                if (this.tima > 255) {
                    this.tima = this.tma;
                    this.IF = (byte)(this.IF | 4);
                }
            }
            this.IF = (byte)(this.IF | this.net.cycle(this.cyclesLeft));
            if (this.video.lcd_on) {
                this.IF = (byte)(this.IF | this.video.cycle(this.cyclesLeft, this));
            }
            if (!this.hdmaDone) {
                if (this.hdmaLastMode != 0 && (byte)(this.video.getStat() & 3) == 0) {
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    if (this.hdmaDst >= this.hdmaStop) {
                        this.hdmaDone = true;
                    }
                }
                this.hdmaLastMode = (byte)(this.video.getStat() & 3);
            }
            this.cycles -= this.cyclesLeft;
            this.recalcCyclesLeft();
        }
    }

    public void setTac(byte by) {
        this.timerOn = (by & 4) == 4;
        this.timeCounter = 0;
        switch (by & 3) {
            case 0: {
                this.timeLimit = 1024;
                break;
            }
            case 1: {
                this.timeLimit = 16;
                break;
            }
            case 2: {
                this.timeLimit = 64;
                break;
            }
            case 3: {
                this.timeLimit = 256;
            }
        }
    }

    public final byte read(int n) {
        switch (n) {
            case 65280: {
                return this.joy.read();
            }
            case 65281: {
                return this.net.getSerialData();
            }
            case 65282: {
                return this.net.getSerialControl();
            }
            case 65283: {
                return 0;
            }
            case 65284: {
                return (byte)(this.div / 256);
            }
            case 65285: {
                return (byte)this.tima;
            }
            case 65286: {
                return (byte)this.tma;
            }
            case 65287: {
                return this.tac;
            }
            case 65295: {
                return this.IF;
            }
            case 65344: {
                return this.video.getLcdc();
            }
            case 65345: {
                return this.video.getStat();
            }
            case 65346: {
                return (byte)this.video.scy;
            }
            case 65347: {
                return (byte)this.video.scx;
            }
            case 65348: {
                return (byte)this.video.ly;
            }
            case 65349: {
                return (byte)this.video.lyc;
            }
            case 65351: {
                return (byte)this.video.bgpal;
            }
            case 65352: {
                return (byte)this.video.objpal0;
            }
            case 65353: {
                return (byte)this.video.objpal1;
            }
            case 65354: {
                return (byte)this.video.wy;
            }
            case 65355: {
                return (byte)this.video.wx;
            }
            case 65357: {
                return this.gbcGetSpeed();
            }
            case 65359: {
                return this.video.gbcGetVram();
            }
            case 65365: {
                return this.getHDMAControl();
            }
            case 65366: {
                return this.net.getIR();
            }
            case 65384: {
                return this.video.gbcGetBgpi();
            }
            case 65385: {
                return this.video.gbcGetBgpd();
            }
            case 65386: {
                return this.video.gbcGetObpi();
            }
            case 65387: {
                return this.video.gbcGetObpd();
            }
            case 65392: {
                return this.gbcGetRamBank();
            }
            case 65407: {
                return 0;
            }
            case 65535: {
                return this.IE;
            }
        }
        if (n < 32768) {
            return this.cart.read(n);
        }
        if (n < 40960) {
            return this.video.read(n);
        }
        if (n < 49152) {
            return this.cart.read(n);
        }
        if (n < 53248) {
            return this.loRAM[n - 49152];
        }
        if (n < 57344) {
            return this.loRAM[n - this.loRAMOffset];
        }
        if (n < 65024) {
            return this.loRAM[n - 57344];
        }
        if (n < 65184) {
            return this.video.read(n);
        }
        if (n < 65295) {
            return 0;
        }
        if (n < 65344) {
            if ((n & 0xFF) == 38) {
                this.soundIO[38] = this.soundChip.channel1.getLength() <= 0 ? (byte)(this.soundIO[38] & 0xFFFFFFFE) : (byte)(this.soundIO[38] | 1);
                this.soundIO[38] = this.soundChip.channel2.getLength() <= 0 ? (byte)(this.soundIO[38] & 0xFFFFFFFD) : (byte)(this.soundIO[38] | 2);
                this.soundIO[38] = this.soundChip.channel3.getLength() <= 0 ? (byte)(this.soundIO[38] & 0xFFFFFFFB) : (byte)(this.soundIO[38] | 4);
                this.soundIO[38] = this.soundChip.channel4.getLength() <= 0 ? (byte)(this.soundIO[38] & 0xFFFFFFF7) : (byte)(this.soundIO[38] | 8);
            }
            return this.soundIO[n & 0xFF];
        }
        if (n < 65365) {
            System.out.println("read GBC register:" + Integer.toHexString(n));
            return 0;
        }
        if (n < 65392) {
            System.out.println("read GBC register:" + Integer.toHexString(n));
            return 0;
        }
        if (n < 65407) {
            System.out.println("read GBC register:" + Integer.toHexString(n));
            return 0;
        }
        if (n < 65535) {
            return this.hiRAM[n - 65408];
        }
        System.out.println("Read from unmapped memory:" + Integer.toHexString(n));
        return 0;
    }

    public final void write(int n, byte by) {
        switch (n) {
            case 65280: {
                if (by == 48 && PgbSettings.system == 10) {
                    this.sgbCommandBit(this.joy.selected);
                }
                this.joy.write(by);
                return;
            }
            case 65281: {
                this.net.setSerialData(by);
                return;
            }
            case 65282: {
                this.net.setSerialControl(by);
                this.recalcCyclesLeft();
                return;
            }
            case 65284: {
                this.div = 0;
                return;
            }
            case 65285: {
                this.tima = by;
                return;
            }
            case 65286: {
                this.tma = by;
                return;
            }
            case 65287: {
                this.setTac(by);
                this.recalcCyclesLeft();
                return;
            }
            case 65296: {
                if (this.soundOn) {
                    this.soundChip.channel1.setSweep((this.unsign(by) & 0x70) >> 4, this.unsign(by) & 7, (this.unsign(by) & 8) == 1);
                }
                this.soundIO[16] = by;
                return;
            }
            case 65297: {
                if (this.soundOn) {
                    this.soundChip.channel1.setDutyCycle((this.unsign(by) & 0xC0) >> 6);
                    if ((this.soundIO[20] & 0x40) == 1) {
                        this.soundChip.channel1.setLength(this.unsign(by) & 0x3F);
                    }
                }
                this.soundIO[17] = by;
                return;
            }
            case 65298: {
                if (this.soundOn) {
                    this.soundChip.channel1.setEnvelope((this.unsign(by) & 0xF0) >> 4, this.unsign(by) & 7, (this.unsign(by) & 8) == 8);
                }
                this.soundIO[18] = by;
                return;
            }
            case 65299: {
                this.soundIO[19] = by;
                if (this.soundOn) {
                    this.soundChip.channel1.setFrequency(((this.unsign(this.soundIO[20]) & 7) << 8) + this.unsign(this.soundIO[19]));
                }
                return;
            }
            case 65300: {
                this.soundIO[20] = by;
                if (this.soundOn) {
                    if ((this.soundIO[20] & 0x80) != 0) {
                        this.soundChip.channel1.setLength(this.unsign(this.soundIO[17]) & 0x3F);
                        this.soundChip.channel1.setEnvelope((this.unsign(this.soundIO[18]) & 0xF0) >> 4, this.unsign(this.soundIO[18]) & 7, (this.unsign(this.soundIO[18]) & 8) == 8);
                        this.soundIO[38] = (byte)(this.soundIO[38] | 1);
                    }
                    if ((this.soundIO[20] & 0x40) == 0) {
                        this.soundChip.channel1.setLength(-1);
                        this.soundIO[38] = (byte)(this.soundIO[38] & 0xFFFFFFFE);
                    }
                    this.soundChip.channel1.setFrequency(((this.unsign(this.soundIO[20]) & 7) << 8) + this.unsign(this.soundIO[19]));
                }
                return;
            }
            case 65301: {
                this.soundIO[21] = by;
                return;
            }
            case 65302: {
                if (this.soundOn) {
                    this.soundChip.channel2.setDutyCycle((this.unsign(by) & 0xC0) >> 6);
                    this.soundChip.channel2.setLength(this.unsign(by) & 0x3F);
                }
                this.soundIO[22] = by;
                return;
            }
            case 65303: {
                if (this.soundOn) {
                    this.soundChip.channel2.setEnvelope((this.unsign(by) & 0xF0) >> 4, this.unsign(by) & 7, (this.unsign(by) & 8) == 8);
                }
                this.soundIO[23] = by;
                return;
            }
            case 65304: {
                this.soundIO[24] = by;
                if (this.soundOn) {
                    this.soundChip.channel2.setFrequency(((this.unsign(this.soundIO[25]) & 7) << 8) + this.unsign(this.soundIO[24]));
                }
                return;
            }
            case 65305: {
                this.soundIO[25] = by;
                if (this.soundOn) {
                    if ((this.soundIO[25] & 0x80) != 0) {
                        this.soundChip.channel2.setLength(this.unsign(this.soundIO[22]) & 0x3F);
                        this.soundChip.channel2.setEnvelope((this.unsign(this.soundIO[23]) & 0xF0) >> 4, this.unsign(this.soundIO[23]) & 7, (this.unsign(this.soundIO[23]) & 8) == 8);
                        this.soundIO[38] = (byte)(this.soundIO[38] | 2);
                    }
                    if ((this.soundIO[25] & 0x40) == 0) {
                        this.soundChip.channel2.setLength(-1);
                        this.soundIO[39] = (byte)(this.soundIO[39] & 0xFFFFFFFD);
                    }
                    this.soundChip.channel2.setFrequency(((this.unsign(this.soundIO[25]) & 7) << 8) + this.unsign(this.soundIO[24]));
                }
                return;
            }
            case 65306: {
                if (this.soundOn) {
                    if ((this.unsign(by) & 0x80) != 0) {
                        this.soundChip.channel3.setVolume((this.unsign(this.soundIO[28]) & 0x60) >> 5);
                    } else {
                        this.soundChip.channel3.setVolume(0);
                    }
                }
                this.soundIO[26] = by;
                return;
            }
            case 65307: {
                this.soundIO[27] = by;
                if (this.soundOn && (this.soundIO[30] & 0x40) == 1) {
                    this.soundChip.channel3.setLength(this.unsign(by));
                }
                return;
            }
            case 65308: {
                this.soundIO[28] = by;
                if (this.soundOn) {
                    this.soundChip.channel3.setVolume((this.unsign(this.soundIO[28]) & 0x60) >> 5);
                }
                return;
            }
            case 65309: {
                this.soundIO[29] = by;
                if (this.soundOn) {
                    this.soundChip.channel3.setFrequency(((this.unsign(this.soundIO[30]) & 7) << 8) + this.unsign(this.soundIO[29]));
                }
                return;
            }
            case 65310: {
                this.soundIO[30] = by;
                if (this.soundOn) {
                    if ((this.soundIO[25] & 0x80) != 0) {
                        this.soundChip.channel3.setLength(this.unsign(this.soundIO[27]));
                        this.soundIO[38] = (byte)(this.soundIO[38] | 4);
                    }
                    this.soundChip.channel3.setFrequency(((this.unsign(this.soundIO[30]) & 7) << 8) + this.unsign(this.soundIO[29]));
                    if ((this.soundIO[30] & 0x40) == 0) {
                        this.soundChip.channel3.setLength(-1);
                        this.soundIO[38] = (byte)(this.soundIO[38] & 0xFFFFFFFB);
                    }
                }
                return;
            }
            case 65312: {
                if (this.soundOn) {
                    this.soundChip.channel4.setLength(this.unsign(by) & 0x3F);
                }
                this.soundIO[32] = by;
                return;
            }
            case 65313: {
                if (this.soundOn) {
                    this.soundChip.channel4.setEnvelope((this.unsign(by) & 0xF0) >> 4, this.unsign(by) & 7, (this.unsign(by) & 8) == 8);
                }
                this.soundIO[33] = by;
                return;
            }
            case 65314: {
                this.soundIO[34] = by;
                return;
            }
            case 65315: {
                this.soundIO[35] = by;
                if (this.soundOn) {
                    if ((this.soundIO[35] & 0x80) != 0) {
                        this.soundChip.channel4.setLength(this.unsign(this.soundIO[32]) & 0x3F);
                        this.soundIO[38] = (byte)(this.soundIO[38] | 8);
                    }
                    if ((this.soundIO[35] & 0x40) == 0) {
                        this.soundChip.channel4.setLength(-1);
                        this.soundIO[38] = (byte)(this.soundIO[38] & 0xFFFFFFF7);
                    }
                }
                return;
            }
            case 65316: {
                this.soundIO[36] = by;
                return;
            }
            case 65317: {
                this.soundIO[37] = by;
                if (this.soundOn) {
                    int n2 = 0;
                    if ((this.unsign(by) & 1) != 0) {
                        n2 |= 1;
                    }
                    if ((this.unsign(by) & 0x10) != 0) {
                        n2 |= 2;
                    }
                    this.soundChip.channel1.setChannel(n2);
                    n2 = 0;
                    if ((this.unsign(by) & 2) != 0) {
                        n2 |= 1;
                    }
                    if ((this.unsign(by) & 0x20) != 0) {
                        n2 |= 2;
                    }
                    this.soundChip.channel2.setChannel(n2);
                    n2 = 0;
                    if ((this.unsign(by) & 4) != 0) {
                        n2 |= 1;
                    }
                    if ((this.unsign(by) & 0x40) != 0) {
                        n2 |= 2;
                    }
                    this.soundChip.channel3.setChannel(n2);
                    n2 = 0;
                    if ((this.unsign(by) & 8) != 0) {
                        n2 |= 1;
                    }
                    if ((this.unsign(by) & 0x80) != 0) {
                        n2 |= 2;
                    }
                    this.soundChip.channel4.setChannel(n2);
                }
                return;
            }
            case 65318: {
                if ((by & 0x80) == 0) {
                    this.soundChip.channel1.setVolume3(0);
                    this.soundChip.channel2.setVolume3(0);
                    this.soundChip.channel3.setVolume(0);
                    this.soundChip.channel4.setLength(-1);
                }
                this.soundIO[38] = by;
                return;
            }
            case 65295: {
                this.IF = by;
                return;
            }
            case 65344: {
                this.video.setLcdc(by);
                this.recalcCyclesLeft();
                return;
            }
            case 65345: {
                this.video.setStat(by);
                this.recalcCyclesLeft();
                return;
            }
            case 65346: {
                this.video.scy = by & 0xFF;
                return;
            }
            case 65347: {
                this.video.scx = by & 0xFF;
                return;
            }
            case 65348: {
                this.video.ly = 0;
                this.recalcCyclesLeft();
                return;
            }
            case 65349: {
                this.video.lyc = by & 0xFF;
                return;
            }
            case 65350: {
                this.oamDMA(by);
                return;
            }
            case 65351: {
                this.video.setBgPal(by & 0xFF);
                return;
            }
            case 65352: {
                this.video.setObjPal0(by & 0xFF);
                return;
            }
            case 65353: {
                this.video.setObjPal1(by & 0xFF);
                return;
            }
            case 65354: {
                this.video.wy = by & 0xFF;
                return;
            }
            case 65355: {
                this.video.wx = by & 0xFF;
                return;
            }
            case 65357: {
                this.gbcSetSpeed(by);
                return;
            }
            case 65359: {
                this.video.gbcSetVram(by);
                return;
            }
            case 65361: {
                this.rHDMA1 = by;
                return;
            }
            case 65362: {
                this.rHDMA2 = by;
                return;
            }
            case 65363: {
                this.rHDMA3 = by;
                return;
            }
            case 65364: {
                this.rHDMA4 = by;
                return;
            }
            case 65365: {
                this.setHDMAControl(by);
                return;
            }
            case 65366: {
                this.net.setIR(by);
                return;
            }
            case 65384: {
                if (PgbSettings.system == 11) {
                    this.video.gbcSetBgpi(by);
                }
                return;
            }
            case 65385: {
                if (PgbSettings.system == 11) {
                    this.video.gbcSetBgpd(by);
                }
                return;
            }
            case 65386: {
                if (PgbSettings.system == 11) {
                    this.video.gbcSetObpi(by);
                }
                return;
            }
            case 65387: {
                if (PgbSettings.system == 11) {
                    this.video.gbcSetObpd(by);
                }
                return;
            }
            case 65392: {
                this.gbcSetRamBank(by);
                return;
            }
            case 65407: {
                System.out.println("write to GBC mystery register FF7F:" + Integer.toHexString(by & 0xFF) + " " + Integer.toBinaryString(by & 0xFF));
                return;
            }
            case 65535: {
                this.IE = by;
                this.recalcCyclesLeft();
                return;
            }
            case 65311: {
                System.out.println("write to GBC mystery register FF1F:" + Integer.toHexString(by & 0xFF) + " " + Integer.toBinaryString(by & 0xFF));
                return;
            }
        }
        if (n < 32768) {
            this.cart.write(n, by);
            return;
        }
        if (n < 40960) {
            this.video.write(n, by);
            return;
        }
        if (n < 49152) {
            this.cart.write(n, by);
            return;
        }
        if (n < 53248) {
            this.loRAM[n - 49152] = by;
            return;
        }
        if (n < 57344) {
            this.loRAM[n - this.loRAMOffset] = by;
            return;
        }
        if (n < 65024) {
            this.loRAM[n - 57344] = by;
            return;
        }
        if (n < 65184) {
            this.video.write(n, by);
            return;
        }
        if (n < 65280 && n >= 65184) {
            return;
        }
        if (n >= 65318 && n <= 65327) {
            this.soundIO[n & 0xFF] = by;
            return;
        }
        if (n >= 65328 && n <= 65343) {
            this.soundIO[n & 0xFF] = by;
            if (this.soundOn) {
                this.soundChip.channel3.setSamplePair(n & 0xF, this.unsign(by));
            }
            return;
        }
        if (n < 65535 && n >= 65408) {
            this.hiRAM[n - 65408] = by;
            return;
        }
        System.out.println("Write to unmapped memory:" + Integer.toHexString(n) + ", " + Integer.toHexString(by));
    }

    public final void write(int n, int n2) {
        this.write(n, (byte)n2);
    }

    public void writeWord(int n, int n2) {
        this.write(n, n2 & 0xFF);
        this.write(n + 1, n2 >> 8);
    }

    public void gbcSetRamBank(byte by) {
        if (PgbSettings.system == 11) {
            this.gbcRAM = by;
            int n = (this.gbcRAM & 7) == 0 ? 0 : (this.gbcRAM & 7) - 1;
            this.loRAMOffset = 49152 - n * 4096;
        }
    }

    public byte gbcGetRamBank() {
        return this.gbcRAM;
    }

    public void gbcSetSpeed(byte by) {
        this.gbcSpeed = by;
    }

    public byte gbcGetSpeed() {
        if (PgbSettings.system == 11) {
            return this.gbcSpeed;
        }
        return 0;
    }

    public void oamDMA(byte by) {
        int n = (by & 0xFF) * 256;
        for (int i = 0; i < 160; ++i) {
            this.video.write(65024 + i, this.read(n + i));
        }
    }

    public void setHDMAControl(byte by) {
        boolean bl = (by & 0x80) == 128;
        int n = ((by & 0x7F) + 1) * 16;
        this.hdmaSrc = (this.rHDMA1 & 0xFF) << 8 | this.rHDMA2 & 0xF0;
        this.hdmaDst = (this.rHDMA3 & 0x1F) << 8 | (this.rHDMA4 & 0xF0) + 32768;
        if (bl) {
            this.hdmaDone = false;
            this.hdmaStop = this.hdmaDst + n;
        } else {
            for (int i = 0; i < n; ++i) {
                this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
            }
        }
    }

    public byte getHDMAControl() {
        return this.hdmaDone ? (byte)1 : 0;
    }

    public void sgbCommandBit(byte by) {
        if (this.sgbPacketCounter == 0 && this.sgbBitCounter == 8) {
            this.sgbCheckCommand();
        }
        if (this.sgbBitCounter == 128) {
            if (++this.sgbPacketCounter == this.sgbPackets) {
                this.sgbCommandExec();
                this.sgbPacketCounter = 0;
            }
            this.sgbBitCounter = 0;
            this.sgbListening = false;
            return;
        }
        if (by == 0) {
            this.sgbListening = true;
            return;
        }
        if (this.sgbListening && by == 16) {
            int n = this.sgbPacketCounter * 16 + this.sgbBitCounter / 8;
            this.sgbBuffer[n] = (byte)(this.sgbBuffer[n] | (byte)(1 << (this.sgbBitCounter & 7)));
            ++this.sgbBitCounter;
            return;
        }
        if (this.sgbListening && by == 32) {
            int n = this.sgbPacketCounter * 16 + this.sgbBitCounter / 8;
            this.sgbBuffer[n] = (byte)(this.sgbBuffer[n] & ~((byte)(1 << (this.sgbBitCounter & 7))));
            ++this.sgbBitCounter;
            return;
        }
    }

    public void sgbCheckCommand() {
        this.sgbCommand = (this.sgbBuffer[0] & 0xF8) >> 3;
        this.sgbPackets = this.sgbBuffer[0] & 7;
    }

    public void sgbCommandExec() {
        switch (this.sgbCommand) {
            case 0: {
                String string = "Download color palettes 0 & 1";
                this.video.sgbSetPalette(0, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(0, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(0, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(0, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(1, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(1, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(1, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(1, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                break;
            }
            case 1: {
                String string = "Download color palettes 2 & 3";
                this.video.sgbSetPalette(2, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(2, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(2, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(2, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(3, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(3, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(3, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(3, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                break;
            }
            case 2: {
                String string = "Download color palettes 0 & 3";
                this.video.sgbSetPalette(0, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(0, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(0, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(0, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(3, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(3, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(3, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(3, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                break;
            }
            case 3: {
                String string = "Download color palettes 1 & 2";
                this.video.sgbSetPalette(1, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(1, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(1, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(1, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(2, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(2, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(2, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(2, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                break;
            }
            case 4: {
                String string = "'Block' Area Designation Mode";
                for (int i = 0; i < this.sgbBuffer[1]; ++i) {
                    this.video.sgbBlockDesignate(this.sgbBuffer[i * 6 + 2], this.sgbBuffer[i * 6 + 3], this.sgbBuffer[i * 6 + 4], this.sgbBuffer[i * 6 + 5], this.sgbBuffer[i * 6 + 6], this.sgbBuffer[i * 6 + 7]);
                }
                break;
            }
            case 5: {
                String string = "'Line' Area Designation Mode";
                for (int i = 0; i < this.sgbBuffer[1]; ++i) {
                    this.video.sgbLineDesignate(this.sgbBuffer[i + 2]);
                }
                break;
            }
            case 6: {
                String string = "'Divide' Area Designation Mode";
                this.video.sgbDivideDesignate(this.sgbBuffer[1], this.sgbBuffer[2]);
                break;
            }
            case 7: {
                String string = "'1CHR' Area Designation Mode";
                for (int i = 0; i < 90; ++i) {
                    this.video.sgbSetPaletteOverlay(i * 4 + 0, this.sgbBuffer[i + 6] & 3);
                    this.video.sgbSetPaletteOverlay(i * 4 + 1, this.sgbBuffer[i + 6] & 3);
                    this.video.sgbSetPaletteOverlay(i * 4 + 2, this.sgbBuffer[i + 6] & 3);
                    this.video.sgbSetPaletteOverlay(i * 4 + 3, this.sgbBuffer[i + 6] & 3);
                }
                break;
            }
            case 8: {
                String string = "Sound On/Off";
                break;
            }
            case 10: {
                String string = "Set SGB Palette Indirect";
                this.video.sgbSetPaletteIndirect((this.sgbBuffer[2] & 1) << 8 | this.sgbBuffer[1] & 0xFF, (this.sgbBuffer[4] & 1) << 8 | this.sgbBuffer[3] & 0xFF, (this.sgbBuffer[6] & 1) << 8 | this.sgbBuffer[5] & 0xFF, (this.sgbBuffer[8] & 1) << 8 | this.sgbBuffer[7] & 0xFF, (this.sgbBuffer[10] & 1) << 8 | this.sgbBuffer[9] & 0xFF);
                break;
            }
            case 11: {
                String string = "Set System Color Palette Data";
                this.video.sgbPaletteTransfer();
                break;
            }
            case 15: {
                String string = "Super NES WRAM Transfer 1";
                break;
            }
            case 17: {
                String string = "Controller 2 Request";
                this.joy.setSgbPlayer(this.sgbBuffer[1]);
                break;
            }
            case 19: {
                String string = "CharSet Transfer";
                this.video.sgbCharsetTransfer((this.sgbBuffer[1] & 4) == 4, (this.sgbBuffer[1] & 1) == 1);
                break;
            }
            case 20: {
                String string = "Picture Transfer";
                this.video.sgbPictureTransfer();
                break;
            }
            case 21: {
                String string = "Set Attribute from ATF";
                this.video.sgbAtfTransfer();
                break;
            }
            case 22: {
                String string = "Set Data from ATF";
                this.video.sgbSetOverlayFromAtf(this.sgbBuffer[1]);
                break;
            }
            case 23: {
                String string = "GameBoy Window Mask";
                if (this.sgbBuffer[1] == 0) {
                    this.video.sgbvramon = false;
                }
                if (this.sgbBuffer[1] != 1 && this.sgbBuffer[1] != 3) break;
                this.video.sgbvramon = true;
                break;
            }
            default: {
                String string = "Unprogrammed";
            }
        }
    }
}

